package mediaplayer.mio;

import anywheresoftware.b4a.B4AMenuItem;
import android.app.Activity;
import android.os.Bundle;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.BALayout;
import anywheresoftware.b4a.B4AActivity;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.ActivityWrapper;
import java.lang.reflect.InvocationTargetException;
import anywheresoftware.b4a.B4AUncaughtException;
import anywheresoftware.b4a.debug.*;
import java.lang.ref.WeakReference;

public class main extends Activity implements B4AActivity{
	public static main mostCurrent;
	static boolean afterFirstLayout;
	static boolean isFirst = true;
    private static boolean processGlobalsRun = false;
	BALayout layout;
	public static BA processBA;
	BA activityBA;
    ActivityWrapper _activity;
    java.util.ArrayList<B4AMenuItem> menuItems;
	private static final boolean fullScreen = false;
	private static final boolean includeTitle = true;
    public static WeakReference<Activity> previousOne;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		if (isFirst) {
			processBA = new BA(this.getApplicationContext(), null, null, "mediaplayer.mio", "main");
			processBA.loadHtSubs(this.getClass());
	        float deviceScale = getApplicationContext().getResources().getDisplayMetrics().density;
	        BALayout.setDeviceScale(deviceScale);
		}
		else if (previousOne != null) {
			Activity p = previousOne.get();
			if (p != null && p != this) {
                anywheresoftware.b4a.keywords.Common.Log("Killing previous instance (main).");
				p.finish();
			}
		}
		if (!includeTitle) {
        	this.getWindow().requestFeature(android.view.Window.FEATURE_NO_TITLE);
        }
        if (fullScreen) {
        	getWindow().setFlags(android.view.WindowManager.LayoutParams.FLAG_FULLSCREEN,   
        			android.view.WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }
		mostCurrent = this;
        processBA.sharedProcessBA.activityBA = null;
		layout = new BALayout(this);
		setContentView(layout);
		afterFirstLayout = false;
		BA.handler.postDelayed(new WaitForLayout(), 5);

	}
	private static class WaitForLayout implements Runnable {
		public void run() {
			if (afterFirstLayout)
				return;
			if (mostCurrent.layout.getWidth() == 0) {
				BA.handler.postDelayed(this, 5);
				return;
			}
			mostCurrent.layout.getLayoutParams().height = mostCurrent.layout.getHeight();
			mostCurrent.layout.getLayoutParams().width = mostCurrent.layout.getWidth();
			afterFirstLayout = true;
			mostCurrent.afterFirstLayout();
		}
	}
	private void afterFirstLayout() {
		activityBA = new BA(this, layout, processBA, "mediaplayer.mio", "main");
        processBA.sharedProcessBA.activityBA = new java.lang.ref.WeakReference<BA>(activityBA);
        _activity = new ActivityWrapper(activityBA, "activity");
        anywheresoftware.b4a.Msgbox.isDismissing = false;
        initializeProcessGlobals();		
        initializeGlobals();
        anywheresoftware.b4a.objects.ViewWrapper.lastId = 0;
        anywheresoftware.b4a.keywords.Common.Log("** Activity (main) Create, isFirst = " + isFirst + " **");
        processBA.raiseEvent2(null, true, "activity_create", false, isFirst);
		isFirst = false;
		if (mostCurrent == null || mostCurrent != this)
			return;
        processBA.setActivityPaused(false);
        anywheresoftware.b4a.keywords.Common.Log("** Activity (main) Resume **");
        processBA.raiseEvent(null, "activity_resume");
        if (android.os.Build.VERSION.SDK_INT >= 11) {
			try {
				android.app.Activity.class.getMethod("invalidateOptionsMenu").invoke(this,(Object[]) null);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}
	public void addMenuItem(B4AMenuItem item) {
		if (menuItems == null)
			menuItems = new java.util.ArrayList<B4AMenuItem>();
		menuItems.add(item);
	}
	@Override
	public boolean onCreateOptionsMenu(android.view.Menu menu) {
		super.onCreateOptionsMenu(menu);
		if (menuItems == null)
			return false;
		for (B4AMenuItem bmi : menuItems) {
			android.view.MenuItem mi = menu.add(bmi.title);
			if (bmi.drawable != null)
				mi.setIcon(bmi.drawable);
            if (android.os.Build.VERSION.SDK_INT >= 11) {
				try {
                    if (bmi.addToBar) {
				        android.view.MenuItem.class.getMethod("setShowAsAction", int.class).invoke(mi, 1);
                    }
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			mi.setOnMenuItemClickListener(new B4AMenuItemsClickListener(bmi.eventName.toLowerCase(BA.cul)));
		}
		return true;
	}
	private class B4AMenuItemsClickListener implements android.view.MenuItem.OnMenuItemClickListener {
		private final String eventName;
		public B4AMenuItemsClickListener(String eventName) {
			this.eventName = eventName;
		}
		public boolean onMenuItemClick(android.view.MenuItem item) {
			processBA.raiseEvent(item.getTitle(), eventName + "_click");
			return true;
		}
	}
    public static Class<?> getObject() {
		return main.class;
	}
    private Boolean onKeySubExist = null;
    private Boolean onKeyUpSubExist = null;
	@Override
	public boolean onKeyDown(int keyCode, android.view.KeyEvent event) {
		if (onKeySubExist == null)
			onKeySubExist = processBA.subExists("activity_keypress");
		if (onKeySubExist) {
			Boolean res =  (Boolean)processBA.raiseEvent2(_activity, false, "activity_keypress", false, keyCode);
			if (res == null || res == true)
				return true;
            else if (keyCode == anywheresoftware.b4a.keywords.constants.KeyCodes.KEYCODE_BACK) {
				finish();
				return true;
			}
		}
		return super.onKeyDown(keyCode, event);
	}
    @Override
	public boolean onKeyUp(int keyCode, android.view.KeyEvent event) {
		if (onKeyUpSubExist == null)
			onKeyUpSubExist = processBA.subExists("activity_keyup");
		if (onKeyUpSubExist) {
			Boolean res =  (Boolean)processBA.raiseEvent2(_activity, false, "activity_keyup", false, keyCode);
			if (res == null || res == true)
				return true;
		}
		return super.onKeyUp(keyCode, event);
	}
	@Override
	public void onNewIntent(android.content.Intent intent) {
		this.setIntent(intent);
	}
    @Override 
	public void onPause() {
		super.onPause();
        if (_activity == null) //workaround for emulator bug (Issue 2423)
            return;
		anywheresoftware.b4a.Msgbox.dismiss(true);
        anywheresoftware.b4a.keywords.Common.Log("** Activity (main) Pause, UserClosed = " + activityBA.activity.isFinishing() + " **");
        processBA.raiseEvent2(_activity, true, "activity_pause", false, activityBA.activity.isFinishing());		
        processBA.setActivityPaused(true);
        mostCurrent = null;
        if (!activityBA.activity.isFinishing())
			previousOne = new WeakReference<Activity>(this);
        anywheresoftware.b4a.Msgbox.isDismissing = false;
	}

	@Override
	public void onDestroy() {
        super.onDestroy();
		previousOne = null;
	}
    @Override 
	public void onResume() {
		super.onResume();
        mostCurrent = this;
        anywheresoftware.b4a.Msgbox.isDismissing = false;
        if (activityBA != null) { //will be null during activity create (which waits for AfterLayout).
        	ResumeMessage rm = new ResumeMessage(mostCurrent);
        	BA.handler.post(rm);
        }
	}
    private static class ResumeMessage implements Runnable {
    	private final WeakReference<Activity> activity;
    	public ResumeMessage(Activity activity) {
    		this.activity = new WeakReference<Activity>(activity);
    	}
		public void run() {
			if (mostCurrent == null || mostCurrent != activity.get())
				return;
			processBA.setActivityPaused(false);
            anywheresoftware.b4a.keywords.Common.Log("** Activity (main) Resume **");
		    processBA.raiseEvent(mostCurrent._activity, "activity_resume", (Object[])null);
		}
    }
	@Override
	protected void onActivityResult(int requestCode, int resultCode,
	      android.content.Intent data) {
		processBA.onActivityResult(requestCode, resultCode, data);
	}
	private static void initializeGlobals() {
		processBA.raiseEvent2(null, true, "globals", false, (Object[])null);
	}

public anywheresoftware.b4a.keywords.Common __c = null;
public static anywheresoftware.b4a.objects.Timer _timer1 = null;
public anywheresoftware.b4a.objects.MediaPlayerWrapper _mp = null;
public anywheresoftware.b4a.objects.CompoundButtonWrapper.ToggleButtonWrapper _togglebutton1 = null;
public anywheresoftware.b4a.objects.ButtonWrapper _button1 = null;
public anywheresoftware.b4a.objects.ButtonWrapper _button2 = null;
public anywheresoftware.b4a.objects.ButtonWrapper _button3 = null;
public anywheresoftware.b4a.objects.SeekBarWrapper _seekbar1 = null;
public anywheresoftware.b4a.objects.SeekBarWrapper _seekbar2 = null;
public anywheresoftware.b4a.objects.LabelWrapper _label2 = null;
public anywheresoftware.b4a.objects.LabelWrapper _label3 = null;
public anywheresoftware.b4a.objects.ProgressBarWrapper _progressbar1 = null;
public static String  _activity_create(boolean _firsttime) throws Exception{
		Debug.PushSubsStack("Activity_Create (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
Debug.locals.put("FirstTime", _firsttime);
 BA.debugLineNum = 18;BA.debugLine="Sub Activity_Create(FirstTime As Boolean)";
Debug.ShouldStop(131072);
 BA.debugLineNum = 19;BA.debugLine="Activity.LoadLayout(\"Layout\") ' Cargamos el Designer";
Debug.ShouldStop(262144);
mostCurrent._activity.LoadLayout("Layout",mostCurrent.activityBA);
 BA.debugLineNum = 21;BA.debugLine="MP.Initialize";
Debug.ShouldStop(1048576);
mostCurrent._mp.Initialize();
 BA.debugLineNum = 22;BA.debugLine="MP.Load(File.DirAssets, \"test_cbr.mp3\")";
Debug.ShouldStop(2097152);
mostCurrent._mp.Load(anywheresoftware.b4a.keywords.Common.File.getDirAssets(),"test_cbr.mp3");
 BA.debugLineNum = 26;BA.debugLine="Timer1.Initialize(\"Timer1\", 500) ' 1000 = 1 segundo";
Debug.ShouldStop(33554432);
_timer1.Initialize(processBA,"Timer1",(long)(500));
 BA.debugLineNum = 27;BA.debugLine="Timer1.Enabled = True";
Debug.ShouldStop(67108864);
_timer1.setEnabled(anywheresoftware.b4a.keywords.Common.True);
 BA.debugLineNum = 28;BA.debugLine="End Sub";
Debug.ShouldStop(134217728);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _button1_click() throws Exception{
		Debug.PushSubsStack("Button1_Click (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
int _minutos = 0;
int _segundos = 0;
 BA.debugLineNum = 29;BA.debugLine="Sub Button1_Click";
Debug.ShouldStop(268435456);
 BA.debugLineNum = 30;BA.debugLine="MP.play";
Debug.ShouldStop(536870912);
mostCurrent._mp.Play();
 BA.debugLineNum = 33;BA.debugLine="Dim minutos, segundos As Int";
Debug.ShouldStop(1);
_minutos = 0;Debug.locals.put("minutos", _minutos);
_segundos = 0;Debug.locals.put("segundos", _segundos);
 BA.debugLineNum = 34;BA.debugLine="segundos = Round(MP.duration / 1000)";
Debug.ShouldStop(2);
_segundos = (int)(anywheresoftware.b4a.keywords.Common.Round(mostCurrent._mp.getDuration()/(double)1000));Debug.locals.put("segundos", _segundos);
 BA.debugLineNum = 35;BA.debugLine="minutos = Floor(segundos / 60) Mod 60";
Debug.ShouldStop(4);
_minutos = (int)(anywheresoftware.b4a.keywords.Common.Floor(_segundos/(double)60)%60);Debug.locals.put("minutos", _minutos);
 BA.debugLineNum = 36;BA.debugLine="segundos = segundos Mod 60";
Debug.ShouldStop(8);
_segundos = (int)(_segundos%60);Debug.locals.put("segundos", _segundos);
 BA.debugLineNum = 38;BA.debugLine="Label2.Text = \"Duración  \" & NumberFormat(minutos,1,0) & \": \" & NumberFormat(segundos,2,0)";
Debug.ShouldStop(32);
mostCurrent._label2.setText((Object)("Duración  "+anywheresoftware.b4a.keywords.Common.NumberFormat(_minutos,(int)(1),(int)(0))+": "+anywheresoftware.b4a.keywords.Common.NumberFormat(_segundos,(int)(2),(int)(0))));
 BA.debugLineNum = 39;BA.debugLine="End Sub";
Debug.ShouldStop(64);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _button2_click() throws Exception{
		Debug.PushSubsStack("Button2_Click (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
 BA.debugLineNum = 40;BA.debugLine="Sub Button2_Click";
Debug.ShouldStop(128);
 BA.debugLineNum = 41;BA.debugLine="MP.pause";
Debug.ShouldStop(256);
mostCurrent._mp.Pause();
 BA.debugLineNum = 42;BA.debugLine="End Sub";
Debug.ShouldStop(512);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _button3_click() throws Exception{
		Debug.PushSubsStack("Button3_Click (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
 BA.debugLineNum = 43;BA.debugLine="Sub Button3_Click";
Debug.ShouldStop(1024);
 BA.debugLineNum = 45;BA.debugLine="MP.stop";
Debug.ShouldStop(4096);
mostCurrent._mp.Stop();
 BA.debugLineNum = 46;BA.debugLine="End Sub";
Debug.ShouldStop(8192);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}

public static void initializeProcessGlobals() {
    if (mostCurrent != null && mostCurrent.activityBA != null) {
Debug.StartDebugging(mostCurrent.activityBA, 39232, new int[] {3}, "7fa9064d-6308-4ba6-ba18-066fca71eacb");}

    if (processGlobalsRun == false) {
	    processGlobalsRun = true;
		try {
		        main._process_globals();
		
        } catch (Exception e) {
			throw new RuntimeException(e);
		}
    }
}

public static boolean isAnyActivityVisible() {
    boolean vis = false;
vis = vis | (main.mostCurrent != null);
return vis;}

public static void killProgram() {
    
            if (main.previousOne != null) {
				Activity a = main.previousOne.get();
				if (a != null)
					a.finish();
			}

}
public static String  _globals() throws Exception{
 //BA.debugLineNum = 9;BA.debugLine="Sub Globals";
 //BA.debugLineNum = 10;BA.debugLine="Dim MP As MediaPlayer";
mostCurrent._mp = new anywheresoftware.b4a.objects.MediaPlayerWrapper();
 //BA.debugLineNum = 11;BA.debugLine="Dim ToggleButton1 As ToggleButton";
mostCurrent._togglebutton1 = new anywheresoftware.b4a.objects.CompoundButtonWrapper.ToggleButtonWrapper();
 //BA.debugLineNum = 12;BA.debugLine="Dim Button1, Button2, Button3 As Button";
mostCurrent._button1 = new anywheresoftware.b4a.objects.ButtonWrapper();
mostCurrent._button2 = new anywheresoftware.b4a.objects.ButtonWrapper();
mostCurrent._button3 = new anywheresoftware.b4a.objects.ButtonWrapper();
 //BA.debugLineNum = 13;BA.debugLine="Dim SeekBar1, SeekBar2 As SeekBar";
mostCurrent._seekbar1 = new anywheresoftware.b4a.objects.SeekBarWrapper();
mostCurrent._seekbar2 = new anywheresoftware.b4a.objects.SeekBarWrapper();
 //BA.debugLineNum = 14;BA.debugLine="Dim Label2, Label3 As Label";
mostCurrent._label2 = new anywheresoftware.b4a.objects.LabelWrapper();
mostCurrent._label3 = new anywheresoftware.b4a.objects.LabelWrapper();
 //BA.debugLineNum = 15;BA.debugLine="Dim ProgressBar1 As ProgressBar";
mostCurrent._progressbar1 = new anywheresoftware.b4a.objects.ProgressBarWrapper();
 //BA.debugLineNum = 16;BA.debugLine="End Sub";
return "";
}
public static String  _process_globals() throws Exception{
 //BA.debugLineNum = 2;BA.debugLine="Sub Process_Globals";
 //BA.debugLineNum = 6;BA.debugLine="Dim Timer1 As Timer";
_timer1 = new anywheresoftware.b4a.objects.Timer();
 //BA.debugLineNum = 7;BA.debugLine="End Sub";
return "";
}
public static String  _seekbar1_valuechanged(int _value,boolean _userchanged) throws Exception{
		Debug.PushSubsStack("SeekBar1_ValueChanged (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
Debug.locals.put("Value", _value);
Debug.locals.put("UserChanged", _userchanged);
 BA.debugLineNum = 47;BA.debugLine="Sub SeekBar1_ValueChanged (Value As Int, UserChanged As Boolean)";
Debug.ShouldStop(16384);
 BA.debugLineNum = 50;BA.debugLine="MP.SetVolume(SeekBar1.Value/100, SeekBar1.Value/100)";
Debug.ShouldStop(131072);
mostCurrent._mp.SetVolume((float)(mostCurrent._seekbar1.getValue()/(double)100),(float)(mostCurrent._seekbar1.getValue()/(double)100));
 BA.debugLineNum = 53;BA.debugLine="End Sub";
Debug.ShouldStop(1048576);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _seekbar2_valuechanged(int _value,boolean _userchanged) throws Exception{
		Debug.PushSubsStack("SeekBar2_ValueChanged (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
Debug.locals.put("Value", _value);
Debug.locals.put("UserChanged", _userchanged);
 BA.debugLineNum = 80;BA.debugLine="Sub SeekBar2_ValueChanged (Value As Int, UserChanged As Boolean)";
Debug.ShouldStop(32768);
 BA.debugLineNum = 82;BA.debugLine="If UserChanged = False Then Return";
Debug.ShouldStop(131072);
if (_userchanged==anywheresoftware.b4a.keywords.Common.False) { 
if (true) return "";};
 BA.debugLineNum = 83;BA.debugLine="MP.position = Value / 100 * MP.duration";
Debug.ShouldStop(262144);
mostCurrent._mp.setPosition((int)(_value/(double)100*mostCurrent._mp.getDuration()));
 BA.debugLineNum = 84;BA.debugLine="If MP.IsPlaying Then";
Debug.ShouldStop(524288);
if (mostCurrent._mp.IsPlaying()) { 
 BA.debugLineNum = 85;BA.debugLine="MP.Play";
Debug.ShouldStop(1048576);
mostCurrent._mp.Play();
 };
 BA.debugLineNum = 87;BA.debugLine="End Sub";
Debug.ShouldStop(4194304);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _timer1_tick() throws Exception{
		Debug.PushSubsStack("Timer1_tick (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
int _minutes = 0;
int _segundes = 0;
 BA.debugLineNum = 64;BA.debugLine="Sub Timer1_tick";
Debug.ShouldStop(-2147483648);
 BA.debugLineNum = 66;BA.debugLine="If MP.IsPlaying Then";
Debug.ShouldStop(2);
if (mostCurrent._mp.IsPlaying()) { 
 BA.debugLineNum = 67;BA.debugLine="ProgressBar1.Progress = MP.position / MP.duration * 100";
Debug.ShouldStop(4);
mostCurrent._progressbar1.setProgress((int)(mostCurrent._mp.getPosition()/(double)mostCurrent._mp.getDuration()*100));
 BA.debugLineNum = 70;BA.debugLine="Dim minutes, segundes As Int";
Debug.ShouldStop(32);
_minutes = 0;Debug.locals.put("minutes", _minutes);
_segundes = 0;Debug.locals.put("segundes", _segundes);
 BA.debugLineNum = 71;BA.debugLine="segundes = Round(MP.position / 1000)";
Debug.ShouldStop(64);
_segundes = (int)(anywheresoftware.b4a.keywords.Common.Round(mostCurrent._mp.getPosition()/(double)1000));Debug.locals.put("segundes", _segundes);
 BA.debugLineNum = 72;BA.debugLine="minutes = Floor(segundes / 60) Mod 60";
Debug.ShouldStop(128);
_minutes = (int)(anywheresoftware.b4a.keywords.Common.Floor(_segundes/(double)60)%60);Debug.locals.put("minutes", _minutes);
 BA.debugLineNum = 73;BA.debugLine="segundes = segundes Mod 60";
Debug.ShouldStop(256);
_segundes = (int)(_segundes%60);Debug.locals.put("segundes", _segundes);
 BA.debugLineNum = 75;BA.debugLine="Label3.Text = \"Posición actual  \" & NumberFormat(minutes,1,0) & \": \" & NumberFormat(segundes,2,0)";
Debug.ShouldStop(1024);
mostCurrent._label3.setText((Object)("Posición actual  "+anywheresoftware.b4a.keywords.Common.NumberFormat(_minutes,(int)(1),(int)(0))+": "+anywheresoftware.b4a.keywords.Common.NumberFormat(_segundes,(int)(2),(int)(0))));
 };
 BA.debugLineNum = 78;BA.debugLine="End Sub";
Debug.ShouldStop(8192);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
public static String  _togglebutton1_checkedchange(boolean _checked) throws Exception{
		Debug.PushSubsStack("ToggleButton1_CheckedChange (main) ","main",0,mostCurrent.activityBA,mostCurrent);
try {
Debug.locals.put("Checked", _checked);
 BA.debugLineNum = 55;BA.debugLine="Sub ToggleButton1_CheckedChange(Checked As Boolean)";
Debug.ShouldStop(4194304);
 BA.debugLineNum = 57;BA.debugLine="If Checked = True Then";
Debug.ShouldStop(16777216);
if (_checked==anywheresoftware.b4a.keywords.Common.True) { 
 BA.debugLineNum = 58;BA.debugLine="MP.Looping = True";
Debug.ShouldStop(33554432);
mostCurrent._mp.setLooping(anywheresoftware.b4a.keywords.Common.True);
 }else {
 BA.debugLineNum = 60;BA.debugLine="MP.Looping = False";
Debug.ShouldStop(134217728);
mostCurrent._mp.setLooping(anywheresoftware.b4a.keywords.Common.False);
 };
 BA.debugLineNum = 62;BA.debugLine="End Sub";
Debug.ShouldStop(536870912);
return "";
}
catch (Exception e) {
			Debug.ErrorCaught(e);
			throw e;
		} 
finally {
			Debug.PopSubsStack();
		}}
  public Object[] GetGlobals() {
		return new Object[] {"Activity",_activity,"Timer1",_timer1,"MP",_mp,"ToggleButton1",_togglebutton1,"Button1",_button1,"Button2",_button2,"Button3",_button3,"SeekBar1",_seekbar1,"SeekBar2",_seekbar2,"Label2",_label2,"Label3",_label3,"ProgressBar1",_progressbar1};
}
}
