; Original: https://www.autoitscript.com/forum/topic/183106-question-regarding-serial-coms/#comment-1314735
; Modificado por Juan Antonio Villalpando
; KIO4.COM
; http://kio4.com/autoit/69C_bluethooth_ordenador_appinventor_chat.htm
; CHAT

#include <GUIConstants.au3>
#include <CommMG.au3>;or if you save the commMg.dll in the @scripdir use #include @SciptDir & '\commmg.dll'
#include <GuiEdit.au3>
#include <GuiComboBox.au3>
#include <windowsconstants.au3>
#include <buttonconstants.au3>
#include <Array.au3>

Opt("WINTITLEMATCHMODE", 3)
HotKeySet("{ESC}", "alldone")

$result = '';used for any returned error message setting port
Const $settitle = "COMMG listExample - set Port", $maintitle = "COMMG Example"
$setflow = 2;default to no flow control
Dim $FlowType[3] = ["Hardware (RTS, CTS)", "XOnXoff", "NONE"]
Dim $ParityType[5] = ["odd", "even", "none", "Mark", "Space"]
#region main program

#Region ### START Koda GUI section ### Form=
$Form2 = GUICreate("COMMG Example", 475, 430, 453, 189)
$Edit1 = GUICtrlCreateEdit("", 2, 33, 449, 311, BitOR($GUI_SS_DEFAULT_EDIT,$ES_READONLY))
GUICtrlSetData(-1, "")
$BtnSend = GUICtrlCreateButton("Send", 380, 353, 53, 30, $BS_FLAT)
$Input1 = GUICtrlCreateInput("", 18, 359, 337, 24)
$BtnSetPort = GUICtrlCreateButton("Set Port", 16, 392, 73, 30, $BS_FLAT)
$Label21 = GUICtrlCreateLabel("Nombre:", 18, 6, 70, 17)
$Input2 = GUICtrlCreateInput("Antonio", 88, 0, 121, 24)
GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###

WinSetTitle($Form2, "", $maintitle & "  UDF = " & _CommGetVersion(1))

While setport(0) = -1
    If MsgBox(4, 'Port not set', 'Do you want to quite the program?') = 6 Then Exit
WEnd

Events()
_CommSetXonXoffProperties(11, 13, 100, 100)
GUICtrlSetState($Edit1, $GUI_FOCUS)

While 1
    $instr = _commGetLine(@CR, 50, 200);_CommGetString() ; CHAT Nmero de caracteres 50

    If $instr <> '' Then ;if we got something
	   $instr = $instr & @CRLF ; CHAT cambio de lnea
	   FileWrite(@ScriptDIr & "/Data.txt", $instr)
	   GUICtrlSetData($Edit1, $instr, 1)
    Else
        Sleep(20) ;MichaelXMike
    EndIf

WEnd

Alldone()


Func Events()
    Opt("GUIOnEventMode", 1)
    GUISetOnEvent($GUI_EVENT_CLOSE, "justgo")
    GUICtrlSetOnEvent($BtnSend, "SendEvent")
    GUICtrlSetOnEvent($BtnSetPort, "SetPortEvent")
EndFunc   ;==>Events

Func SetPortEvent()
    setport();needed because a parameter is optional for setport so we can't use "setport" for the event
    GUICtrlSetState($Edit1, $GUI_FOCUS)
EndFunc   ;==>SetPortEvent

Func justgo()
    Exit
EndFunc   ;==>justgo

Func SendEvent();send the text in the inputand append CR
	$poner = "- " & GUICtrlRead($Input2) & ": " & GUICtrlRead($Input1) & @CRLF ; CHAT
	GUICtrlSetData($Edit1, $poner, 1) ; CHAT aadir al Edit1
	_CommSendstring($poner) ; CHAT
    GUICtrlSetData($Input1, '') ;clear the input
EndFunc   ;==>SendEvent


Func AllDone()
    _Commcloseport(true)
    Exit
EndFunc   ;==>AllDone


Func SetPort($mode = 1);if $mode = 1 then returns -1 if settings not made
    Local $sportSetError
    Opt("GUIOnEventMode", 0);keep events for $Form2, use GuiGetMsg for $Form3

    #Region ### START Koda GUI section ### Form=d:\my documents\miscdelphi\commg\examplecommsetport.kxf
    $Form3 = GUICreate("COMMG Example - set Port", 422, 279, 329, 268, BitOR($WS_MINIMIZEBOX, $WS_CAPTION, $WS_POPUP, $WS_GROUP, $WS_BORDER, $WS_CLIPSIBLINGS, _
	$DS_MODALFRAME), BitOR($WS_EX_TOPMOST, $WS_EX_WINDOWEDGE))

    $Group1 = GUICtrlCreateGroup("Set COM Port", 18, 8, 288, 252)
    $CmboPortsAvailable = GUICtrlCreateCombo("", 127, 28, 145, 25, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_SORT))
    $CmBoBaud = GUICtrlCreateCombo("9600", 127, 66, 145, 25, BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL, $CBS_SORT, $WS_VSCROLL))
    GUICtrlSetData(-1, "115200|1200|128000|14400")
    $CmBoStop = GUICtrlCreateCombo("1", 127, 141, 145, 25)
    GUICtrlSetData(-1, "1|2|1.5")
    $CmBoParity = GUICtrlCreateCombo("", 127, 178, 145, 25)
    GUICtrlSetData(-1, "odd|even|none|Mark|Space")
    GUICtrlSetData(-1, "none")
    $Label2 = GUICtrlCreateLabel("Port", 94, 32, 23, 17)
    $Label3 = GUICtrlCreateLabel("baud", 89, 70, 28, 17)
    $Label4 = GUICtrlCreateLabel("No. Stop bits", 52, 145, 65, 17)
    $Label5 = GUICtrlCreateLabel("parity", 88, 182, 29, 17)
    $CmboDataBits = GUICtrlCreateCombo("8", 127, 103, 145, 25)
    GUICtrlSetData(-1, "7|8")
    $Label7 = GUICtrlCreateLabel("No. of Data Bits", 38, 107, 79, 17)
    $ComboFlow = GUICtrlCreateCombo("NONE", 127, 216, 145, 25)
    GUICtrlSetData(-1, "NONE|XOnXOff|Hardware (RTS, CTS)")
    $Label1 = GUICtrlCreateLabel("flow control", 59, 220, 58, 17)
    GUICtrlCreateGroup("", -99, -99, 1, 1)
    $BtnApply = GUICtrlCreateButton("Apply", 315, 95, 75, 35, $BS_FLAT)
    GUICtrlSetFont(-1, 12, 400, 0, "MS Sans Serif")
    $BtnCancel = GUICtrlCreateButton("Cancel", 316, 147, 76, 35, $BS_FLAT)
    GUICtrlSetFont(-1, 12, 400, 0, "MS Sans Serif")
    GUISetState(@SW_SHOW)
    #EndRegion ### END Koda GUI section ###


    WinSetTitle($Form3, "", $settitle) ;ensure a change to Koda design doesn't stop script working
    $mainxy = WinGetPos($Form2)
    WinMove($Form3, "", $mainxy[0] + 20, $mainxy[1] + 20)

    $portlist = _CommListPorts(0);find the available COM ports and write them into the ports combo
    If @error = 1 Then
        MsgBox(0, 'trouble getting portlist', 'Program will terminate!')
        Exit
    EndIf

    For $pl = 1 To $portlist[0]
        $portnum = StringReplace($portlist[$pl], "COM", '')
        if StringLen($portnum) = 1 then $portnum = ' ' & $portnum
        $portlist[$pl] = 'COM' & $portnum
        GUICtrlSetData($CmboPortsAvailable, $portlist[$pl]) ;_CommListPorts())
    Next
    GUICtrlSetData($CmboPortsAvailable, $portlist[1]) ;show the first port found
    GUICtrlSetData($ComboFlow, $FlowType[$setflow])

    _GUICtrlComboBox_SetMinVisible($CmBoBaud, 10) ;restrict the length of the drop-down list

    $retval = 0

    While 1
        $msg = GUIGetMsg()
        If $msg = $BtnCancel Then
            If Not $mode Then $retval = -1
            ExitLoop
        EndIf

        If $msg = $BtnApply Then

            $comboflowsel = GUICtrlRead($ComboFlow)
            For $n = 0 To 2
                If $comboflowsel = $FlowType[$n] Then
                    $setflow = $n
                    ExitLoop
                EndIf

            Next
            $setport = StringReplace(GUICtrlRead($CmboPortsAvailable), 'COM', '')

            $ParitySel = GUICtrlRead($CmBoParity)
            For $n = 0 To 4
                If $ParitySel = $ParityType[$n] Then
                    $SetParity = $n
                    ExitLoop
                EndIf
            Next

            $setStop = StringReplace(GUICtrlRead($CmBoStop), '.', '');replace 1.5 with 15 if needed

	$resOpen = _CommSetPort($setport, $sportSetError, GUICtrlRead($CmBoBaud), GUICtrlRead($CmboDataBits), $SetParity, $setStop, $setflow)

            if $resOpen = 0 then
                Exit
            EndIf

            Sleep(1000)
            $mode = 1;
            ExitLoop
        EndIf
        ;stop user switching back to $form2
        If WinActive($maintitle) Then
            ConsoleWrite('main is active' & @CRLF)
            If WinActivate($settitle) = 0 Then MsgBox(0, 'not found', $settitle)
        EndIf

    WEnd

    GUIDelete($Form3)
    WinActivate($maintitle)
    Events()
    Return $retval

EndFunc