/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.InterpolateStrategy;

public class SigmoidInterpolation
implements InterpolateStrategy {
    private float sharpness;
    private float sharpPremult;

    public SigmoidInterpolation() {
        this(2.0f);
    }

    public SigmoidInterpolation(float f) {
        this.setSharpness(f);
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public float interpolate(float f, float f2, float f3) {
        f3 = (f3 * 2.0f - 1.0f) * this.sharpPremult;
        f3 = (float)(1.0 / (1.0 + Math.exp(-f3)));
        return f + (f2 - f) * f3;
    }

    private void setSharpness(float f) {
        this.sharpness = f;
        this.sharpPremult = 5.0f * f;
    }
}

