/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import toxi.geom.AABB;
import toxi.geom.Intersector3D;
import toxi.geom.IsectData3D;
import toxi.geom.Matrix4x4;
import toxi.geom.Quaternion;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Sphere;
import toxi.geom.Triangle3D;
import toxi.geom.TriangleIntersector;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Face;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.OBJWriter;
import toxi.geom.mesh.STLWriter;
import toxi.geom.mesh.Vertex;
import toxi.geom.mesh.WETriangleMesh;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleMesh
implements Mesh3D,
Intersector3D {
    public static final int DEFAULT_NUM_VERTICES = 1000;
    public static final int DEFAULT_NUM_FACES = 3000;
    public static final int DEFAULT_STRIDE = 4;
    protected static final Logger logger = Logger.getLogger(TriangleMesh.class.getName());
    public String name;
    public LinkedHashMap<Vec3D, Vertex> vertices;
    public ArrayList<Face> faces;
    protected AABB bounds;
    protected Vec3D centroid = new Vec3D();
    protected int numVertices;
    protected int numFaces;
    protected Matrix4x4 matrix = new Matrix4x4();
    protected TriangleIntersector intersector = new TriangleIntersector();
    protected int uniqueVertexID;

    public TriangleMesh() {
        this("untitled");
    }

    public TriangleMesh(String string) {
        this(string, 1000, 3000);
    }

    public TriangleMesh(String string, int n, int n2) {
        this.init(string, n, n2);
    }

    @Override
    public TriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        return this.addFace(vec3D, vec3D2, vec3D3, null, null, null, null);
    }

    @Override
    public TriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        return this.addFace(vec3D, vec3D2, vec3D3, null, vec2D, vec2D2, vec2D3);
    }

    @Override
    public TriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4) {
        return this.addFace(vec3D, vec3D2, vec3D3, vec3D4, null, null, null);
    }

    @Override
    public TriangleMesh addFace(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4, Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        Vertex vertex = this.checkVertex(vec3D);
        Vertex vertex2 = this.checkVertex(vec3D2);
        Vertex vertex3 = this.checkVertex(vec3D3);
        if (vertex.id == vertex2.id || vertex.id == vertex3.id || vertex2.id == vertex3.id) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ignorning invalid face: " + vec3D + "," + vec3D2 + "," + vec3D3);
            }
        } else {
            Object object;
            if (vec3D4 != null && vec3D4.dot((Vec3D)(object = vertex.sub(vertex3).crossSelf(vertex.sub(vertex2)))) < 0.0f) {
                Vertex vertex4 = vertex;
                vertex = vertex2;
                vertex2 = vertex4;
            }
            object = new Face(vertex, vertex2, vertex3, vec2D, vec2D2, vec2D3);
            this.faces.add((Face)object);
            ++this.numFaces;
        }
        return this;
    }

    @Override
    public TriangleMesh addMesh(Mesh3D mesh3D) {
        for (Face face : mesh3D.getFaces()) {
            this.addFace(face.a, face.b, face.c, face.uvA, face.uvB, face.uvC);
        }
        return this;
    }

    @Override
    public AABB center(ReadonlyVec3D readonlyVec3D) {
        this.computeCentroid();
        Vec3D vec3D = readonlyVec3D != null ? readonlyVec3D.sub(this.centroid) : this.centroid.getInverted();
        for (Vertex vertex : this.vertices.values()) {
            vertex.addSelf(vec3D);
        }
        this.getBoundingBox();
        return this.bounds;
    }

    private final Vertex checkVertex(Vec3D vec3D) {
        Vertex vertex = this.vertices.get(vec3D);
        if (vertex == null) {
            vertex = this.createVertex(vec3D, this.uniqueVertexID++);
            this.vertices.put(vertex, vertex);
            ++this.numVertices;
        }
        return vertex;
    }

    @Override
    public TriangleMesh clear() {
        this.vertices.clear();
        this.faces.clear();
        this.bounds = null;
        this.numVertices = 0;
        this.numFaces = 0;
        return this;
    }

    @Override
    public Vec3D computeCentroid() {
        this.centroid.clear();
        for (Vertex vertex : this.vertices.values()) {
            this.centroid.addSelf(vertex);
        }
        return this.centroid.scaleSelf(1.0f / (float)this.numVertices).copy();
    }

    @Override
    public TriangleMesh computeFaceNormals() {
        for (Face face : this.faces) {
            face.computeNormal();
        }
        return this;
    }

    @Override
    public TriangleMesh computeVertexNormals() {
        for (Vertex object : this.vertices.values()) {
            object.clearNormal();
        }
        for (Face face : this.faces) {
            face.a.addFaceNormal(face.normal);
            face.b.addFaceNormal(face.normal);
            face.c.addFaceNormal(face.normal);
        }
        for (Vertex vertex : this.vertices.values()) {
            vertex.computeNormal();
        }
        return this;
    }

    public TriangleMesh copy() {
        TriangleMesh triangleMesh = new TriangleMesh(this.name + "-copy", this.numVertices, this.numFaces);
        for (Face face : this.faces) {
            triangleMesh.addFace(face.a, face.b, face.c, face.normal, face.uvA, face.uvB, face.uvC);
        }
        return triangleMesh;
    }

    protected Vertex createVertex(Vec3D vec3D, int n) {
        return new Vertex(vec3D, n);
    }

    @Override
    public TriangleMesh faceOutwards() {
        this.computeCentroid();
        for (Face face : this.faces) {
            Vec3D vec3D = face.getCentroid().sub(this.centroid);
            float f = vec3D.dot(face.normal);
            if (!(f < 0.0f)) continue;
            face.flipVertexOrder();
        }
        return this;
    }

    @Override
    public TriangleMesh flipVertexOrder() {
        for (Face face : this.faces) {
            Vertex vertex = face.a;
            face.a = face.b;
            face.b = vertex;
            face.normal.invert();
        }
        return this;
    }

    @Override
    public TriangleMesh flipYAxis() {
        this.transform(new Matrix4x4().scaleSelf(1.0, -1.0, 1.0));
        this.flipVertexOrder();
        return this;
    }

    @Override
    public AABB getBoundingBox() {
        Vec3D vec3D = Vec3D.MAX_VALUE.copy();
        Vec3D vec3D2 = Vec3D.MIN_VALUE.copy();
        for (Vertex vertex : this.vertices.values()) {
            vec3D.minSelf(vertex);
            vec3D2.maxSelf(vertex);
        }
        this.bounds = AABB.fromMinMax(vec3D, vec3D2);
        return this.bounds;
    }

    @Override
    public Sphere getBoundingSphere() {
        float f = 0.0f;
        this.computeCentroid();
        for (Vertex vertex : this.vertices.values()) {
            f = MathUtils.max(f, vertex.distanceToSquared(this.centroid));
        }
        return new Sphere(this.centroid, (float)Math.sqrt(f));
    }

    @Override
    public Vertex getClosestVertexToPoint(ReadonlyVec3D readonlyVec3D) {
        Vertex vertex = null;
        float f = Float.MAX_VALUE;
        for (Vertex vertex2 : this.vertices.values()) {
            float f2 = vertex2.distanceToSquared(readonlyVec3D);
            if (!(f2 < f)) continue;
            vertex = vertex2;
            f = f2;
        }
        return vertex;
    }

    public float[] getFaceNormalsAsArray() {
        return this.getFaceNormalsAsArray(null, 0, 4);
    }

    public float[] getFaceNormalsAsArray(float[] fArray, int n, int n2) {
        n2 = MathUtils.max(n2, 3);
        if (fArray == null) {
            fArray = new float[this.faces.size() * 3 * n2];
        }
        int n3 = n;
        for (Face face : this.faces) {
            fArray[n3] = face.normal.x;
            fArray[n3 + 1] = face.normal.y;
            fArray[n3 + 2] = face.normal.z;
            fArray[n3 += n2] = face.normal.x;
            fArray[n3 + 1] = face.normal.y;
            fArray[n3 + 2] = face.normal.z;
            fArray[n3 += n2] = face.normal.x;
            fArray[n3 + 1] = face.normal.y;
            fArray[n3 + 2] = face.normal.z;
            n3 += n2;
        }
        return fArray;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public int[] getFacesAsArray() {
        int[] nArray = new int[this.faces.size() * 3];
        int n = 0;
        for (Face face : this.faces) {
            nArray[n++] = face.a.id;
            nArray[n++] = face.b.id;
            nArray[n++] = face.c.id;
        }
        return nArray;
    }

    @Override
    public IsectData3D getIntersectionData() {
        return this.intersector.getIntersectionData();
    }

    public float[] getMeshAsVertexArray() {
        return this.getMeshAsVertexArray(null, 0, 4);
    }

    public float[] getMeshAsVertexArray(float[] fArray, int n, int n2) {
        n2 = MathUtils.max(n2, 3);
        if (fArray == null) {
            fArray = new float[this.faces.size() * 3 * n2];
        }
        int n3 = n;
        for (Face face : this.faces) {
            fArray[n3] = face.a.x;
            fArray[n3 + 1] = face.a.y;
            fArray[n3 + 2] = face.a.z;
            fArray[n3 += n2] = face.b.x;
            fArray[n3 + 1] = face.b.y;
            fArray[n3 + 2] = face.b.z;
            fArray[n3 += n2] = face.c.x;
            fArray[n3 + 1] = face.c.y;
            fArray[n3 + 2] = face.c.z;
            n3 += n2;
        }
        return fArray;
    }

    @Override
    public int getNumFaces() {
        return this.numFaces;
    }

    @Override
    public int getNumVertices() {
        return this.numVertices;
    }

    public TriangleMesh getRotatedAroundAxis(Vec3D vec3D, float f) {
        return this.copy().rotateAroundAxis(vec3D, f);
    }

    public TriangleMesh getRotatedX(float f) {
        return this.copy().rotateX(f);
    }

    public TriangleMesh getRotatedY(float f) {
        return this.copy().rotateY(f);
    }

    public TriangleMesh getRotatedZ(float f) {
        return this.copy().rotateZ(f);
    }

    public TriangleMesh getScaled(float f) {
        return this.copy().scale(f);
    }

    public TriangleMesh getScaled(Vec3D vec3D) {
        return this.copy().scale(vec3D);
    }

    public TriangleMesh getTranslated(Vec3D vec3D) {
        return this.copy().translate(vec3D);
    }

    public float[] getUniqueVerticesAsArray() {
        float[] fArray = new float[this.numVertices * 3];
        int n = 0;
        for (Vertex vertex : this.vertices.values()) {
            fArray[n++] = vertex.x;
            fArray[n++] = vertex.y;
            fArray[n++] = vertex.z;
        }
        return fArray;
    }

    public Vertex getVertexAtPoint(Vec3D vec3D) {
        return this.vertices.get(vec3D);
    }

    public Vertex getVertexForID(int n) {
        Vertex vertex = null;
        for (Vertex vertex2 : this.vertices.values()) {
            if (vertex2.id != n) continue;
            vertex = vertex2;
            break;
        }
        return vertex;
    }

    public float[] getVertexNormalsAsArray() {
        return this.getVertexNormalsAsArray(null, 0, 4);
    }

    public float[] getVertexNormalsAsArray(float[] fArray, int n, int n2) {
        n2 = MathUtils.max(n2, 3);
        if (fArray == null) {
            fArray = new float[this.faces.size() * 3 * n2];
        }
        int n3 = n;
        for (Face face : this.faces) {
            fArray[n3] = face.a.normal.x;
            fArray[n3 + 1] = face.a.normal.y;
            fArray[n3 + 2] = face.a.normal.z;
            fArray[n3 += n2] = face.b.normal.x;
            fArray[n3 + 1] = face.b.normal.y;
            fArray[n3 + 2] = face.b.normal.z;
            fArray[n3 += n2] = face.c.normal.x;
            fArray[n3 + 1] = face.c.normal.y;
            fArray[n3 + 2] = face.c.normal.z;
            n3 += n2;
        }
        return fArray;
    }

    @Override
    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    protected void handleSaveAsSTL(STLWriter sTLWriter, boolean bl) {
        if (bl) {
            sTLWriter.setScale(new Vec3D(1.0f, -1.0f, 1.0f));
            for (Face face : this.faces) {
                sTLWriter.face(face.a, face.b, face.c, face.normal, -1);
            }
        } else {
            for (Face face : this.faces) {
                sTLWriter.face(face.b, face.a, face.c, face.normal, -1);
            }
        }
        sTLWriter.endSave();
        logger.info(this.numFaces + " faces written");
    }

    @Override
    public TriangleMesh init(String string, int n, int n2) {
        this.setName(string);
        this.vertices = new LinkedHashMap(n, 1.5f, false);
        this.faces = new ArrayList(n2);
        return this;
    }

    @Override
    public boolean intersectsRay(Ray3D ray3D) {
        Triangle3D triangle3D = this.intersector.getTriangle();
        for (Face face : this.faces) {
            triangle3D.a = face.a;
            triangle3D.b = face.b;
            triangle3D.c = face.c;
            if (!this.intersector.intersectsRay(ray3D)) continue;
            return true;
        }
        return false;
    }

    public Triangle3D perforateFace(Face face, float f) {
        Vec3D vec3D = face.getCentroid();
        float f2 = 1.0f - f;
        Vec3D vec3D2 = face.a.interpolateTo(vec3D, f2);
        Vec3D vec3D3 = face.b.interpolateTo(vec3D, f2);
        Vec3D vec3D4 = face.c.interpolateTo(vec3D, f2);
        this.removeFace(face);
        this.addFace(face.a, vec3D3, vec3D2);
        this.addFace(face.a, face.b, vec3D3);
        this.addFace(face.b, vec3D4, vec3D3);
        this.addFace(face.b, face.c, vec3D4);
        this.addFace(face.c, vec3D2, vec3D4);
        this.addFace(face.c, face.a, vec3D2);
        return new Triangle3D(vec3D2, vec3D3, vec3D4);
    }

    public TriangleMesh pointTowards(ReadonlyVec3D readonlyVec3D) {
        return this.transform(Quaternion.getAlignmentQuat(readonlyVec3D, Vec3D.Z_AXIS).toMatrix4x4(this.matrix), true);
    }

    public TriangleMesh pointTowards(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        return this.transform(Quaternion.getAlignmentQuat(readonlyVec3D, readonlyVec3D2).toMatrix4x4(this.matrix), true);
    }

    public void removeFace(Face face) {
        this.faces.remove(face);
    }

    public TriangleMesh rotateAroundAxis(Vec3D vec3D, float f) {
        return this.transform(this.matrix.identity().rotateAroundAxis(vec3D, f));
    }

    public TriangleMesh rotateX(float f) {
        return this.transform(this.matrix.identity().rotateX(f));
    }

    public TriangleMesh rotateY(float f) {
        return this.transform(this.matrix.identity().rotateY(f));
    }

    public TriangleMesh rotateZ(float f) {
        return this.transform(this.matrix.identity().rotateZ(f));
    }

    public void saveAsOBJ(OBJWriter oBJWriter) {
        int n = oBJWriter.getCurrVertexOffset() + 1;
        int n2 = oBJWriter.getCurrNormalOffset() + 1;
        logger.info("writing OBJMesh: " + this.toString());
        oBJWriter.newObject(this.name);
        for (Vertex object : this.vertices.values()) {
            oBJWriter.vertex(object);
        }
        for (Vertex vertex : this.vertices.values()) {
            oBJWriter.normal(vertex.normal);
        }
        for (Face face : this.faces) {
            oBJWriter.faceWithNormals(face.b.id + n, face.a.id + n, face.c.id + n, face.b.id + n2, face.a.id + n2, face.c.id + n2);
        }
    }

    public void saveAsOBJ(OutputStream outputStream) {
        OBJWriter oBJWriter = new OBJWriter();
        oBJWriter.beginSave(outputStream);
        this.saveAsOBJ(oBJWriter);
        oBJWriter.endSave();
    }

    public void saveAsOBJ(String string) {
        OBJWriter oBJWriter = new OBJWriter();
        oBJWriter.beginSave(string);
        this.saveAsOBJ(oBJWriter);
        oBJWriter.endSave();
    }

    public final void saveAsSTL(OutputStream outputStream) {
        this.saveAsSTL(outputStream, false);
    }

    public final void saveAsSTL(OutputStream outputStream, boolean bl) {
        STLWriter sTLWriter = new STLWriter();
        sTLWriter.beginSave(outputStream, this.numFaces);
        this.handleSaveAsSTL(sTLWriter, bl);
    }

    public final void saveAsSTL(OutputStream outputStream, STLWriter sTLWriter, boolean bl) {
        sTLWriter.beginSave(outputStream, this.numFaces);
        this.handleSaveAsSTL(sTLWriter, bl);
    }

    public final void saveAsSTL(String string) {
        this.saveAsSTL(string, false);
    }

    public final void saveAsSTL(String string, boolean bl) {
        this.saveAsSTL(string, new STLWriter(), bl);
    }

    public final void saveAsSTL(String string, STLWriter sTLWriter, boolean bl) {
        sTLWriter.beginSave(string, this.numFaces);
        this.handleSaveAsSTL(sTLWriter, bl);
    }

    public TriangleMesh scale(float f) {
        return this.transform(this.matrix.identity().scaleSelf(f));
    }

    public TriangleMesh scale(Vec3D vec3D) {
        return this.transform(this.matrix.identity().scaleSelf(vec3D));
    }

    @Override
    public TriangleMesh setName(String string) {
        this.name = string;
        return this;
    }

    public String toString() {
        return "TriangleMesh: " + this.name + " vertices: " + this.getNumVertices() + " faces: " + this.getNumFaces();
    }

    public WETriangleMesh toWEMesh() {
        return new WETriangleMesh(this.name, this.vertices.size(), this.faces.size()).addMesh(this);
    }

    public TriangleMesh transform(Matrix4x4 matrix4x4) {
        return this.transform(matrix4x4, true);
    }

    public TriangleMesh transform(Matrix4x4 matrix4x4, boolean bl) {
        for (Vertex vertex : this.vertices.values()) {
            vertex.set(matrix4x4.applyTo(vertex));
        }
        if (bl) {
            this.computeFaceNormals();
        }
        return this;
    }

    public TriangleMesh translate(Vec3D vec3D) {
        return this.transform(this.matrix.identity().translateSelf(vec3D));
    }

    public TriangleMesh updateVertex(Vec3D vec3D, Vec3D vec3D2) {
        Vertex vertex = this.vertices.get(vec3D);
        if (vertex != null) {
            this.vertices.remove(vertex);
            vertex.set(vec3D2);
            this.vertices.put(vertex, vertex);
        }
        return this;
    }
}

