/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Sphere;
import toxi.geom.Vec3D;
import toxi.geom.mesh.SurfaceFunction;
import toxi.math.MathUtils;

public class SphereFunction
implements SurfaceFunction {
    public Sphere sphere;
    protected float phiRange = (float)Math.PI;
    protected float thetaRange = (float)Math.PI * 2;

    public SphereFunction() {
        this(1.0f);
    }

    public SphereFunction(float f) {
        this(new Sphere(new Vec3D(), f));
    }

    public SphereFunction(Sphere sphere) {
        this.sphere = sphere;
    }

    public Vec3D computeVertexFor(Vec3D vec3D, float f, float f2) {
        float f3 = MathUtils.cos(f -= 1.5707964f);
        float f4 = MathUtils.cos(f2);
        float f5 = MathUtils.sin(f);
        float f6 = MathUtils.sin(f2);
        float f7 = (float)MathUtils.sign(f3) * MathUtils.abs(f3);
        vec3D.x = f7 * (float)MathUtils.sign(f4) * MathUtils.abs(f4);
        vec3D.y = (float)MathUtils.sign(f5) * MathUtils.abs(f5);
        vec3D.z = f7 * (float)MathUtils.sign(f6) * MathUtils.abs(f6);
        return vec3D.scaleSelf(this.sphere.radius).addSelf(this.sphere);
    }

    public float getPhiRange() {
        return this.phiRange;
    }

    public int getPhiResolutionLimit(int n) {
        return n;
    }

    public float getThetaRange() {
        return this.thetaRange;
    }

    public int getThetaResolutionLimit(int n) {
        return n;
    }

    public void setMaxPhi(float f) {
        this.phiRange = MathUtils.min(f / 2.0f, (float)Math.PI);
    }

    public void setMaxTheta(float f) {
        this.thetaRange = MathUtils.min(f, (float)Math.PI * 2);
    }
}

