/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import toxi.geom.BernsteinPolynomial;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Spline3D {
    public static final float DEFAULT_TIGHTNESS = 0.25f;
    public static final int DEFAULT_RES = 16;
    @XmlElement
    protected Vec3D[] points;
    @XmlElement(name="p")
    public List<Vec3D> pointList = new ArrayList<Vec3D>();
    @XmlTransient
    public List<Vec3D> vertices;
    @XmlTransient
    public BernsteinPolynomial bernstein;
    @XmlTransient
    public Vec3D[] delta;
    @XmlTransient
    public Vec3D[] coeffA;
    @XmlTransient
    public float[] bi;
    @XmlAttribute
    protected float tightness;
    @XmlTransient
    protected float invTightness;
    @XmlTransient
    protected int numP;
    @XmlTransient
    protected float[] arcLenIndex;

    public Spline3D() {
        this.setTightness(0.25f);
    }

    public Spline3D(List<Vec3D> list) {
        this(list, null, 0.25f);
    }

    public Spline3D(List<Vec3D> list, BernsteinPolynomial bernsteinPolynomial, float f) {
        this.pointList.addAll(list);
        this.bernstein = bernsteinPolynomial;
        this.setTightness(f);
    }

    public Spline3D(Vec3D[] vec3DArray) {
        this(vec3DArray, null, 0.25f);
    }

    public Spline3D(Vec3D[] vec3DArray, BernsteinPolynomial bernsteinPolynomial, float f) {
        this(Arrays.asList(vec3DArray), bernsteinPolynomial, f);
    }

    public Spline3D add(float f, float f2, float f3) {
        return this.add(new Vec3D(f, f2, f3));
    }

    public Spline3D add(ReadonlyVec3D readonlyVec3D) {
        this.pointList.add(readonlyVec3D.copy());
        return this;
    }

    public List<Vec3D> computeVertices(int n) {
        this.updateCoefficients();
        if (n < 1) {
            n = 1;
        }
        if (this.bernstein == null || this.bernstein.resolution != ++n) {
            this.bernstein = new BernsteinPolynomial(n);
        }
        if (this.vertices == null) {
            this.vertices = new ArrayList<Vec3D>();
        } else {
            this.vertices.clear();
        }
        this.findCPoints();
        Vec3D vec3D = new Vec3D();
        Vec3D vec3D2 = new Vec3D();
        --n;
        for (int i = 0; i < this.numP - 1; ++i) {
            Vec3D vec3D3 = this.points[i];
            Vec3D vec3D4 = this.points[i + 1];
            vec3D.set(this.delta[i]).addSelf(vec3D3);
            vec3D2.set(vec3D4).subSelf(this.delta[i + 1]);
            for (int j = 0; j < n; ++j) {
                float f = vec3D3.x * this.bernstein.b0[j] + vec3D.x * this.bernstein.b1[j] + vec3D2.x * this.bernstein.b2[j] + vec3D4.x * this.bernstein.b3[j];
                float f2 = vec3D3.y * this.bernstein.b0[j] + vec3D.y * this.bernstein.b1[j] + vec3D2.y * this.bernstein.b2[j] + vec3D4.y * this.bernstein.b3[j];
                float f3 = vec3D3.z * this.bernstein.b0[j] + vec3D.z * this.bernstein.b1[j] + vec3D2.z * this.bernstein.b2[j] + vec3D4.z * this.bernstein.b3[j];
                this.vertices.add(new Vec3D(f, f2, f3));
            }
        }
        this.vertices.add(this.points[this.points.length - 1]);
        return this.vertices;
    }

    protected void findCPoints() {
        int n;
        this.bi[1] = -this.tightness;
        this.coeffA[1].set((this.points[2].x - this.points[0].x - this.delta[0].x) * this.tightness, (this.points[2].y - this.points[0].y - this.delta[0].y) * this.tightness, (this.points[2].z - this.points[0].z - this.delta[0].z) * this.tightness);
        for (n = 2; n < this.numP - 1; ++n) {
            this.bi[n] = -1.0f / (this.invTightness + this.bi[n - 1]);
            this.coeffA[n].set(-(this.points[n + 1].x - this.points[n - 1].x - this.coeffA[n - 1].x) * this.bi[n], -(this.points[n + 1].y - this.points[n - 1].y - this.coeffA[n - 1].y) * this.bi[n], -(this.points[n + 1].z - this.points[n - 1].z - this.coeffA[n - 1].z) * this.bi[n]);
        }
        for (n = this.numP - 2; n > 0; --n) {
            this.delta[n].set(this.coeffA[n].x + this.delta[n + 1].x * this.bi[n], this.coeffA[n].y + this.delta[n + 1].y * this.bi[n], this.coeffA[n].z + this.delta[n + 1].z * this.bi[n]);
        }
    }

    public List<Vec3D> getDecimatedVertices(float f) {
        return this.getDecimatedVertices(f, true);
    }

    public List<Vec3D> getDecimatedVertices(float f, boolean bl) {
        if (this.vertices == null || this.vertices.size() < 2) {
            this.computeVertices(16);
        }
        float f2 = this.getEstimatedArcLength();
        ArrayList<Vec3D> arrayList = new ArrayList<Vec3D>();
        double d = f / f2;
        int n = 0;
        for (double d2 = 0.0; d2 < 1.0; d2 += d) {
            double d3 = d2 * (double)f2;
            while (d3 >= (double)this.arcLenIndex[n]) {
                ++n;
            }
            ReadonlyVec3D readonlyVec3D = this.vertices.get(n - 1);
            Vec3D vec3D = this.vertices.get(n);
            float f3 = (float)((d3 - (double)this.arcLenIndex[n - 1]) / (double)(this.arcLenIndex[n] - this.arcLenIndex[n - 1]));
            Vec3D vec3D2 = readonlyVec3D.interpolateTo(vec3D, f3);
            arrayList.add(vec3D2);
        }
        if (bl) {
            arrayList.add(this.vertices.get(this.vertices.size() - 1));
        }
        return arrayList;
    }

    public float getEstimatedArcLength() {
        if (this.arcLenIndex == null || this.arcLenIndex != null && this.arcLenIndex.length != this.vertices.size()) {
            this.arcLenIndex = new float[this.vertices.size()];
        }
        float f = 0.0f;
        for (int i = 1; i < this.arcLenIndex.length; ++i) {
            ReadonlyVec3D readonlyVec3D = this.vertices.get(i - 1);
            Vec3D vec3D = this.vertices.get(i);
            this.arcLenIndex[i] = f += readonlyVec3D.distanceTo(vec3D);
        }
        return f;
    }

    public int getNumPoints() {
        return this.numP;
    }

    public List<Vec3D> getPointList() {
        return this.pointList;
    }

    public float getTightness() {
        return this.tightness;
    }

    public Spline3D setPointList(List<Vec3D> list) {
        this.pointList.clear();
        for (Vec3D vec3D : list) {
            this.add(vec3D);
        }
        return this;
    }

    public Spline3D setTightness(float f) {
        this.tightness = f;
        this.invTightness = 1.0f / f;
        return this;
    }

    public void updateCoefficients() {
        this.numP = this.pointList.size();
        if (this.points == null || this.points != null && this.points.length != this.numP) {
            this.coeffA = new Vec3D[this.numP];
            this.delta = new Vec3D[this.numP];
            this.bi = new float[this.numP];
            for (int i = 0; i < this.numP; ++i) {
                this.coeffA[i] = new Vec3D();
                this.delta[i] = new Vec3D();
            }
            this.setTightness(this.tightness);
        }
        this.points = this.pointList.toArray(new Vec3D[0]);
    }
}

