/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;
import toxi.volume.VolumetricSpace;

public abstract class VolumetricBrush {
    protected static final Logger logger = Logger.getLogger(VolumetricBrush.class.getName());
    public static final int MODE_ADDITIVE = 1;
    public static final int MODE_MULTIPLY = 2;
    public static final int MODE_REPLACE = 3;
    protected VolumetricSpace volume;
    protected int cellRadiusX;
    protected int cellRadiusY;
    protected int cellRadiusZ;
    protected float stretchY;
    protected float stretchZ;
    protected int brushMode = 1;

    public VolumetricBrush(VolumetricSpace volumetricSpace) {
        this.volume = volumetricSpace;
    }

    public void drawAtAbsolutePos(Vec3D vec3D, float f) {
        float f2 = MathUtils.clip((float)((vec3D.x + this.volume.halfScale.x) / this.volume.scale.x * (float)this.volume.resX1), (float)0.0f, (float)this.volume.resX1);
        float f3 = MathUtils.clip((float)((vec3D.y + this.volume.halfScale.y) / this.volume.scale.y * (float)this.volume.resY1), (float)0.0f, (float)this.volume.resY1);
        float f4 = MathUtils.clip((float)((vec3D.z + this.volume.halfScale.z) / this.volume.scale.z * (float)this.volume.resZ1), (float)0.0f, (float)this.volume.resZ1);
        this.drawAtGridPos(f2, f3, f4, f);
    }

    public abstract void drawAtGridPos(float var1, float var2, float var3, float var4);

    public void setMode(int n) {
        this.brushMode = n;
    }

    public abstract void setSize(float var1);

    protected final void updateVoxel(int n, int n2, int n3, float f) {
        int n4 = this.volume.getIndexFor(n, n2, n3);
        switch (this.brushMode) {
            default: {
                this.volume.setVoxelAt(n4, this.volume.getVoxelAt(n4) + f);
                break;
            }
            case 2: {
                this.volume.setVoxelAt(n4, this.volume.getVoxelAt(n4) * f);
                break;
            }
            case 3: {
                this.volume.setVoxelAt(n4, f);
            }
        }
    }
}

