/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.logging.Level;
import toxi.math.MathUtils;
import toxi.volume.VolumetricBrush;
import toxi.volume.VolumetricSpace;

public class RoundBrush
extends VolumetricBrush {
    protected float radius;
    protected float radSquared;

    public RoundBrush(VolumetricSpace volumetricSpace, float f) {
        super(volumetricSpace);
        this.setSize(f);
    }

    public void drawAtGridPos(float f, float f2, float f3, float f4) {
        int n = MathUtils.max((int)((int)(f - (float)this.cellRadiusX)), (int)0);
        int n2 = MathUtils.max((int)((int)(f2 - (float)this.cellRadiusY)), (int)0);
        int n3 = MathUtils.max((int)((int)(f3 - (float)this.cellRadiusZ)), (int)0);
        int n4 = MathUtils.min((int)((int)(f + (float)this.cellRadiusX)), (int)this.volume.resX);
        int n5 = MathUtils.min((int)((int)(f2 + (float)this.cellRadiusY)), (int)this.volume.resY);
        int n6 = MathUtils.min((int)((int)(f3 + (float)this.cellRadiusZ)), (int)this.volume.resZ);
        for (int i = n3; i < n6; ++i) {
            float f5 = ((float)i - f3) * this.stretchZ;
            f5 *= f5;
            for (int j = n2; j < n5; ++j) {
                float f6 = ((float)j - f2) * this.stretchY;
                f6 = f6 * f6 + f5;
                for (int k = n; k < n4; ++k) {
                    float f7 = (float)k - f;
                    float f8 = (float)Math.sqrt(f7 * f7 + f6);
                    if (!(f8 <= (float)this.cellRadiusX)) continue;
                    float f9 = (1.0f - f8 / (float)this.cellRadiusX) * f4;
                    this.updateVoxel(k, j, i, f9);
                }
            }
        }
    }

    public void setSize(float f) {
        this.radius = f;
        this.cellRadiusX = (int)(f / this.volume.scale.x * (float)this.volume.resX + 1.0f);
        this.cellRadiusY = (int)(f / this.volume.scale.y * (float)this.volume.resY + 1.0f);
        this.cellRadiusZ = (int)(f / this.volume.scale.z * (float)this.volume.resZ + 1.0f);
        this.stretchY = (float)this.cellRadiusX / (float)this.cellRadiusY;
        this.stretchZ = (float)this.cellRadiusX / (float)this.cellRadiusZ;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("new brush size: " + f);
        }
    }
}

