/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.WETriangleMesh;
import toxi.geom.mesh.WingedEdge;
import toxi.math.ScaleMap;
import toxi.util.datatypes.FloatRange;
import toxi.volume.HashIsoSurface;
import toxi.volume.RoundBrush;
import toxi.volume.VolumetricBrush;
import toxi.volume.VolumetricHashMap;

public class MeshLatticeBuilder {
    protected static final Logger logger = Logger.getLogger(MeshLatticeBuilder.class.getName());

    public static WETriangleMesh build(WETriangleMesh wETriangleMesh, int n, float f) {
        return MeshLatticeBuilder.build(wETriangleMesh, n, new FloatRange(f, f));
    }

    public static WETriangleMesh build(WETriangleMesh wETriangleMesh, int n, FloatRange floatRange) {
        WingedEdge wingedEdge2;
        logger.info("creating lattice...");
        VolumetricHashMap volumetricHashMap = new VolumetricHashMap(wETriangleMesh.getBoundingBox().getExtent().scale(2.0f), n, n, n, 0.33f);
        RoundBrush roundBrush = new RoundBrush(volumetricHashMap, 1.0f);
        ArrayList<Float> arrayList = new ArrayList<Float>(wETriangleMesh.edges.size());
        for (WingedEdge wingedEdge2 : wETriangleMesh.edges.values()) {
            arrayList.add(Float.valueOf(wingedEdge2.getLength()));
        }
        FloatRange floatRange2 = FloatRange.fromSamples(arrayList);
        wingedEdge2 = new ScaleMap((double)floatRange2.min, (double)floatRange2.max, (double)floatRange.min, (double)floatRange.max);
        for (WingedEdge wingedEdge3 : wETriangleMesh.edges.values()) {
            List list = wingedEdge3.splitIntoSegments(null, 1.0f, true);
            ((VolumetricBrush)roundBrush).setSize((float)wingedEdge2.getClippedValueFor((double)wingedEdge3.getLength()));
            for (Vec3D vec3D : list) {
                roundBrush.drawAtAbsolutePos(vec3D, 0.5f);
            }
        }
        logger.info("volume density: " + volumetricHashMap.getDensity());
        volumetricHashMap.closeSides();
        wETriangleMesh = null;
        Object object = new HashIsoSurface(volumetricHashMap);
        wETriangleMesh = (WETriangleMesh)object.computeSurfaceMesh((Mesh3D)new WETriangleMesh("iso", 300000, 900000), 0.2f);
        logger.info("created lattice mesh: " + wETriangleMesh);
        volumetricHashMap = null;
        object = null;
        return wETriangleMesh;
    }
}

