/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.logging.Level;
import toxi.math.MathUtils;
import toxi.volume.VolumetricBrush;
import toxi.volume.VolumetricSpace;

public class BoxBrush
extends VolumetricBrush {
    public BoxBrush(VolumetricSpace volumetricSpace, float f) {
        super(volumetricSpace);
        this.setSize(f);
    }

    public void drawAtGridPos(float f, float f2, float f3, float f4) {
        int n = MathUtils.max((int)((int)(f - (float)this.cellRadiusX)), (int)0);
        int n2 = MathUtils.max((int)((int)(f2 - (float)this.cellRadiusY)), (int)0);
        int n3 = MathUtils.max((int)((int)(f3 - (float)this.cellRadiusZ)), (int)0);
        int n4 = MathUtils.min((int)((int)(f + (float)this.cellRadiusX)), (int)this.volume.resX);
        int n5 = MathUtils.min((int)((int)(f2 + (float)this.cellRadiusY)), (int)this.volume.resY);
        int n6 = MathUtils.min((int)((int)(f3 + (float)this.cellRadiusZ)), (int)this.volume.resZ);
        for (int i = n3; i < n6; ++i) {
            for (int j = n2; j < n5; ++j) {
                for (int k = n; k < n4; ++k) {
                    this.updateVoxel(k, j, i, f4);
                }
            }
        }
    }

    public void setSize(float f) {
        this.setSize(f, f, f);
    }

    public void setSize(float f, float f2, float f3) {
        this.cellRadiusX = (int)(f * 0.5f / this.volume.scale.x * (float)this.volume.resX + 1.0f);
        this.cellRadiusY = (int)(f2 * 0.5f / this.volume.scale.y * (float)this.volume.resY + 1.0f);
        this.cellRadiusZ = (int)(f3 * 0.5f / this.volume.scale.z * (float)this.volume.resZ + 1.0f);
        this.stretchY = (float)this.cellRadiusX / (float)this.cellRadiusY;
        this.stretchZ = (float)this.cellRadiusX / (float)this.cellRadiusZ;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("new brush size: " + this.cellRadiusX + "x" + this.cellRadiusY + "x" + this.cellRadiusZ);
        }
    }
}

