/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import java.nio.ByteBuffer;
import toxi.audio.AudioBuffer;
import toxi.audio.JOALUtil;

public class SynthUtil {
    public static AudioBuffer floatArrayTo16bitBuffer(JOALUtil jOALUtil, float[] fArray, int n) {
        byte[] byArray = SynthUtil.floatArrayTo16bitPCM(fArray);
        AudioBuffer audioBuffer = jOALUtil.generateBuffers(1)[0];
        audioBuffer.configure(ByteBuffer.wrap(byArray), AudioBuffer.Format.MONO16, n);
        return audioBuffer;
    }

    public static byte[] floatArrayTo16bitPCM(float[] fArray) {
        byte[] byArray = new byte[fArray.length * 2];
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = (int)(fArray[i] * 32768.0f);
            byArray[n++] = (byte)(n2 & 0xFF);
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        }
        return byArray;
    }

    public static AudioBuffer floatArrayTo16bitStereoBuffer(JOALUtil jOALUtil, float[] fArray, int n) {
        byte[] byArray = SynthUtil.floatArrayTo16bitPCM(fArray);
        AudioBuffer audioBuffer = jOALUtil.generateBuffers(1)[0];
        audioBuffer.configure(ByteBuffer.wrap(byArray), AudioBuffer.Format.STEREO16, n);
        return audioBuffer;
    }

    public static AudioBuffer floatArrayTo8bitBuffer(JOALUtil jOALUtil, float[] fArray, int n) {
        byte[] byArray = SynthUtil.floatArrayTo8bitPCM(fArray);
        AudioBuffer audioBuffer = jOALUtil.generateBuffers(1)[0];
        audioBuffer.configure(ByteBuffer.wrap(byArray), AudioBuffer.Format.MONO8, n);
        return audioBuffer;
    }

    public static byte[] floatArrayTo8bitPCM(float[] fArray) {
        byte[] byArray = new byte[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            byArray[i] = (byte)(fArray[i] * 127.0f + 128.0f);
        }
        return byArray;
    }

    public static AudioBuffer floatArrayTo8bitStereoBuffer(JOALUtil jOALUtil, float[] fArray, int n) {
        byte[] byArray = SynthUtil.floatArrayTo8bitPCM(fArray);
        AudioBuffer audioBuffer = jOALUtil.generateBuffers(1)[0];
        audioBuffer.configure(ByteBuffer.wrap(byArray), AudioBuffer.Format.STEREO8, n);
        return audioBuffer;
    }

    public static float[] joinMonoFloatArrays(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("left & right channels need to be of equal size");
        }
        float[] fArray3 = new float[fArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < fArray.length) {
            fArray3[n2] = fArray[n];
            fArray3[n2 + 1] = fArray2[n];
            ++n;
            n2 += 2;
        }
        return fArray3;
    }
}

