/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import java.util.logging.Logger;
import toxi.audio.AudioSource;
import toxi.audio.JOALUtil;

public class MultiTimbralManager {
    private static final Logger logger = Logger.getLogger(MultiTimbralManager.class.getName());
    protected SourceState[] pool;
    protected int maxSources;
    protected int currIndex;

    public MultiTimbralManager(JOALUtil jOALUtil, int n) {
        logger.info("attempting to allocate " + n + " audio voices");
        AudioSource[] audioSourceArray = jOALUtil.generateSources(n);
        this.maxSources = audioSourceArray.length;
        this.pool = new SourceState[this.maxSources];
        for (int i = 0; i < this.maxSources; ++i) {
            AudioSource audioSource = audioSourceArray[i];
            audioSource.setReferenceDistance(100.0f);
            audioSource.setGain(1.0f);
            this.pool[i] = new SourceState(audioSource);
        }
        logger.info("done. all sources created.");
    }

    public void debug() {
        String string = "";
        int n = 0;
        for (int i = 0; i < this.maxSources; ++i) {
            if (!this.pool[i].isActive) continue;
            string = string + i + ",";
            ++n;
        }
        String string2 = "active sources: " + n;
        logger.info(string2);
        logger.info(string);
    }

    public AudioSource getNextVoice() {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.currIndex;
        do {
            n = this.currIndex;
            this.currIndex = (this.currIndex + 1) % this.maxSources;
            if (this.pool[n].isActive) {
                if (this.pool[n].updateStatus()) continue;
                bl = true;
                continue;
            }
            bl = true;
        } while (!bl && ++n2 < this.maxSources);
        if (!bl) {
            long l = System.currentTimeMillis();
            n = n3;
            for (int i = 0; i < this.maxSources; ++i) {
                if (this.pool[i].startTime >= l) continue;
                n = i;
                l = this.pool[i].startTime;
            }
            this.pool[n].src.stop();
            logger.warning("no free src, using oldest slot #" + n);
            this.currIndex = (n + 1) % this.maxSources;
        }
        this.pool[n].activate();
        return this.pool[n].src;
    }

    public boolean[] getUsage() {
        boolean[] blArray = new boolean[this.maxSources];
        for (int i = 0; i < this.maxSources; ++i) {
            blArray[i] = this.pool[i].isActive;
        }
        return blArray;
    }

    static class SourceState {
        AudioSource src;
        boolean isActive;
        long startTime;

        SourceState(AudioSource audioSource) {
            this.src = audioSource;
        }

        void activate() {
            this.isActive = true;
            this.startTime = System.currentTimeMillis();
        }

        boolean updateStatus() {
            this.isActive = this.isActive && (this.src.isLooping() || this.src.getBuffersProcessed() == 0);
            return this.isActive;
        }
    }
}

