/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import net.java.games.joal.eax.EAX;
import net.java.games.joal.eax.EAXFactory;
import net.java.games.joal.util.WAVData;
import net.java.games.joal.util.WAVLoader;
import toxi.audio.AudioBuffer;
import toxi.audio.AudioSource;
import toxi.audio.SoundListener;

public class JOALUtil {
    public static String HARDWARE = "Generic Hardware";
    public static String SOFTWARE = "Generic Software";
    public static final Logger logger = Logger.getLogger(JOALUtil.class.getName());
    protected static JOALUtil instance;
    protected ArrayList<AudioBuffer> buffers;
    protected ArrayList<AudioSource> sources;
    protected SoundListener listener;
    protected AL al;
    protected ALC alc;
    protected ALCcontext context;
    protected ALCdevice device;
    protected EAX eax;
    protected boolean isInited;
    protected boolean isEAX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JOALUtil getInstance() {
        if (instance != null) return instance;
        Class<JOALUtil> clazz = JOALUtil.class;
        synchronized (JOALUtil.class) {
            if (instance != null) return instance;
            instance = new JOALUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected JOALUtil() {
    }

    public void deleteAll() {
        logger.info("deleting all sources & buffers...");
        while (this.sources.size() > 0) {
            this.deleteSource(this.sources.get(0), true);
        }
        this.sources.clear();
        this.buffers.clear();
    }

    public boolean deleteBuffer(AudioBuffer audioBuffer) {
        if (audioBuffer != null) {
            for (AudioSource audioSource : this.sources) {
                if (audioSource.getBuffer() != audioBuffer) continue;
                audioSource.stop();
                logger.fine("forced stopping source: " + (Object)((Object)audioSource));
            }
            boolean bl = audioBuffer.delete();
            if (this.buffers.remove(audioBuffer)) {
                logger.info("deleted buffer: " + audioBuffer);
            }
            return bl;
        }
        logger.warning("attempted to delete null buffer");
        return true;
    }

    public boolean deleteSource(AudioSource audioSource) {
        return this.deleteSource(audioSource, false);
    }

    public boolean deleteSource(AudioSource audioSource, boolean bl) {
        AudioBuffer audioBuffer = audioSource.getBuffer();
        boolean bl2 = audioSource.delete();
        if (this.sources.remove((Object)audioSource)) {
            logger.info("deleted source: " + (Object)((Object)audioSource));
        } else {
            logger.warning("deleted unmanaged source: " + (Object)((Object)audioSource));
        }
        if (bl && audioBuffer != null) {
            bl2 = bl2 && this.deleteBuffer(audioBuffer);
        }
        return bl2;
    }

    public AudioBuffer[] generateBuffers(int n) {
        if (!this.isInited) {
            this.init();
        }
        AudioBuffer[] audioBufferArray = new AudioBuffer[n];
        int[] nArray = new int[n];
        this.al.alGenBuffers(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            audioBufferArray[i] = new AudioBuffer(this.al, nArray[i]);
            this.buffers.add(audioBufferArray[i]);
        }
        return audioBufferArray;
    }

    public AudioSource generateSource() {
        return this.generateSources(1)[0];
    }

    public AudioSource generateSourceFromFile(String string) {
        if (!this.isInited) {
            this.init();
        }
        AudioSource audioSource = null;
        AudioBuffer audioBuffer = this.loadBuffer(string);
        if (audioBuffer != null) {
            audioSource = this.generateSource();
            audioSource.setBuffer(audioBuffer);
        }
        return audioSource;
    }

    public AudioSource[] generateSources(int n) {
        if (!this.isInited) {
            this.init();
        }
        AudioSource[] audioSourceArray = new AudioSource[n];
        int[] nArray = new int[n];
        this.al.alGenSources(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            audioSourceArray[i] = new AudioSource(this.al, nArray[i]);
            this.sources.add(audioSourceArray[i]);
        }
        return audioSourceArray;
    }

    public AL getAL() {
        if (!this.isInited) {
            this.init();
        }
        return this.al;
    }

    public String[] getDeviceList() {
        if (this.alc == null) {
            this.alc = ALFactory.getALC();
        }
        return this.alc.alcGetDeviceSpecifiers();
    }

    public SoundListener getListener() {
        if (!this.isInited) {
            this.init();
        }
        if (this.listener == null) {
            this.listener = new SoundListener(this);
        }
        return this.listener;
    }

    public boolean init() {
        return this.init(null, false);
    }

    public boolean init(String string, boolean bl) {
        ALCdevice aLCdevice;
        if (this.context != null) {
            throw new ALException("OpenAL already initialized");
        }
        if (this.al == null) {
            this.al = ALFactory.getAL();
        }
        if (this.alc == null) {
            this.alc = ALFactory.getALC();
        }
        if ((aLCdevice = this.alc.alcOpenDevice(string)) == null) {
            throw new ALException("Error opening default OpenAL device");
        }
        ALCcontext aLCcontext = this.alc.alcCreateContext(aLCdevice, null);
        if (aLCcontext == null) {
            this.alc.alcCloseDevice(aLCdevice);
            throw new ALException("Error creating OpenAL context");
        }
        this.alc.alcMakeContextCurrent(aLCcontext);
        if (this.alc.alcGetError(aLCdevice) != 0) {
            this.alc.alcDestroyContext(aLCcontext);
            this.alc.alcCloseDevice(aLCdevice);
            throw new ALException("Error making OpenAL context current");
        }
        this.device = aLCdevice;
        this.context = aLCcontext;
        this.isInited = this.al.alGetError() == 0;
        this.buffers = new ArrayList();
        this.sources = new ArrayList();
        this.listener = new SoundListener(this);
        this.isEAX = this.al.alIsExtensionPresent("EAX2.0");
        if (this.isEAX && bl) {
            this.initEAX();
        }
        return this.isInited;
    }

    protected void initEAX() {
        this.eax = EAXFactory.getEAX();
        IntBuffer intBuffer = IntBuffer.allocate(1);
        intBuffer.put(10);
        this.eax.setListenerProperty(11, (Buffer)intBuffer);
    }

    public boolean isEAXSupported() {
        return this.isEAX;
    }

    public AudioBuffer loadBuffer(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioBuffer[] audioBufferArray = this.generateBuffers(1);
        AudioBuffer audioBuffer = audioBufferArray[0];
        WAVData wAVData = WAVLoader.loadFromStream((InputStream)inputStream);
        audioBuffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return audioBuffer;
    }

    public AudioBuffer loadBuffer(String string) {
        AudioBuffer audioBuffer = null;
        try {
            WAVData wAVData = WAVLoader.loadFromFile((String)string);
            AudioBuffer[] audioBufferArray = this.generateBuffers(1);
            audioBuffer = audioBufferArray[0];
            audioBuffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            logger.severe(unsupportedAudioFileException.getMessage());
        }
        return audioBuffer;
    }

    public void shutdown() {
        if (this.isInited) {
            logger.info("shutting down JOAL");
            this.deleteAll();
            this.alc.alcMakeContextCurrent(null);
            this.alc.alcDestroyContext(this.context);
            this.alc.alcCloseDevice(this.device);
            this.context = null;
            this.device = null;
            this.alc = null;
            this.al = null;
            this.buffers = null;
            this.sources = null;
            this.isInited = false;
        }
    }
}

