/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import toxi.math.MathUtils;
import toxi.math.SinCosLUT;

public class IIRFilter {
    protected static final SinCosLUT sinTable = new SinCosLUT(0.05f);
    protected final Type type;
    protected float b0;
    protected float b1;
    protected float b2;
    protected float a0;
    protected float a1;
    protected float a2;
    protected float alpha;
    protected float out1;
    protected float out2;
    protected float in1;
    protected float in2;
    protected final float sampleRate;
    protected final float sampleRateRadians;
    protected float decay = 0.999f;

    public IIRFilter(Type type, float f) {
        this.type = type;
        this.sampleRate = f;
        this.sampleRateRadians = (float)Math.PI * 2 / f;
    }

    public float calculateAmplitude(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = this.a0 * (this.b0 * fArray[i] + this.b1 * this.in1 + this.b2 * this.in2 - this.a1 * this.out1 - this.a2 * this.out2);
            this.in2 = this.in1;
            this.in1 = fArray[i];
            this.out2 = this.out1;
            this.out1 = f2;
            if (f < MathUtils.abs((float)f2)) {
                f = f2;
                continue;
            }
            f *= this.decay;
        }
        return f;
    }

    public IIRFilter clear() {
        this.in2 = 0.0f;
        this.in1 = 0.0f;
        this.out2 = 0.0f;
        this.out1 = 0.0f;
        return this;
    }

    public float filter(float f) {
        float f2 = this.a0 * (this.b0 * f + this.b1 * this.in1 + this.b2 * this.in2 - this.a1 * this.out1 - this.a2 * this.out2);
        this.in2 = this.in1;
        this.in1 = f;
        this.out2 = this.out1;
        this.out1 = f2;
        return f2;
    }

    public float filter(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = this.a0 * (this.b0 * fArray[i] + this.b1 * this.in1 + this.b2 * this.in2 - this.a1 * this.out1 - this.a2 * this.out2);
            this.in2 = this.in1;
            this.in1 = fArray[i];
            this.out2 = this.out1;
            this.out1 = f2;
            fArray[i] = f2;
            if (f < MathUtils.abs((float)fArray[i])) {
                f = fArray[i];
                continue;
            }
            f *= this.decay;
        }
        return f;
    }

    public float getDecay() {
        return this.decay;
    }

    public IIRFilter init(float f, float f2) {
        float f3 = this.sampleRateRadians * f;
        float f4 = sinTable.sin(f3);
        float f5 = sinTable.cos(f3);
        this.alpha = f4 / f2;
        this.a0 = 1.0f / (1.0f + this.alpha);
        this.a1 = -2.0f * f5;
        this.a2 = 1.0f - this.alpha;
        switch (this.type) {
            case LOWPASS: {
                this.b0 = this.b2 = (1.0f - f5) * 0.5f;
                this.b1 = 1.0f - f5;
                break;
            }
            case HIGHPASS: {
                this.b0 = this.b2 = (1.0f + f5) * 0.5f;
                this.b1 = -(1.0f + f5);
                break;
            }
            case BANDPASS: {
                this.b0 = f4 * 0.5f;
                this.b1 = 0.0f;
                this.b2 = -f4 * 0.5f;
            }
        }
        return this;
    }

    public IIRFilter setDecay(float f) {
        this.decay = f;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LOWPASS,
        HIGHPASS,
        BANDPASS;

    }
}

