/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d.behaviors;

import toxi.geom.Vec2D;
import toxi.physics2d.VerletParticle2D;
import toxi.physics2d.behaviors.ParticleBehavior2D;

public class AttractionBehavior
implements ParticleBehavior2D {
    protected Vec2D attractor;
    protected float attrStrength;
    protected float radius;
    protected float radiusSquared;
    protected float strength;
    protected float jitter;
    protected float timeStep;

    public AttractionBehavior(Vec2D vec2D, float f, float f2) {
        this(vec2D, f, f2, 0.0f);
    }

    public AttractionBehavior(Vec2D vec2D, float f, float f2, float f3) {
        this.attractor = vec2D;
        this.strength = f2;
        this.jitter = f3;
        this.setRadius(f);
    }

    public void apply(VerletParticle2D verletParticle2D) {
        Vec2D vec2D = this.attractor.sub((Vec2D)verletParticle2D);
        float f = vec2D.magSquared();
        if (f < this.radiusSquared) {
            Vec2D vec2D2 = vec2D.normalizeTo(1.0f - f / this.radiusSquared).jitter(this.jitter).scaleSelf(this.attrStrength);
            verletParticle2D.addForce(vec2D2);
        }
    }

    public void configure(float f) {
        this.timeStep = f;
        this.setStrength(this.strength);
    }

    public Vec2D getAttractor() {
        return this.attractor;
    }

    public float getJitter() {
        return this.jitter;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setAttractor(Vec2D vec2D) {
        this.attractor = vec2D;
    }

    public void setJitter(float f) {
        this.jitter = f;
    }

    private void setRadius(float f) {
        this.radius = f;
        this.radiusSquared = f * f;
    }

    public void setStrength(float f) {
        this.strength = f;
        this.attrStrength = f * this.timeStep;
    }
}

