/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics.constraints;

import toxi.geom.ReadonlyVec3D;
import toxi.geom.Sphere;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.constraints.ParticleConstraint;

public class SphereConstraint
implements ParticleConstraint {
    public Sphere sphere;
    public boolean isBoundingSphere;
    public static final boolean INSIDE = true;
    public static final boolean OUTSIDE = false;

    public SphereConstraint(Sphere sphere, boolean bl) {
        this.sphere = sphere;
        this.isBoundingSphere = bl;
    }

    public SphereConstraint(Vec3D vec3D, float f, boolean bl) {
        this.sphere = new Sphere((ReadonlyVec3D)vec3D, f);
        this.isBoundingSphere = bl;
    }

    public void apply(VerletParticle verletParticle) {
        boolean bl = this.sphere.containsPoint((ReadonlyVec3D)verletParticle);
        if (this.isBoundingSphere && !bl || !this.isBoundingSphere && bl) {
            verletParticle.set(this.sphere.add(verletParticle.subSelf((Vec3D)this.sphere).normalizeTo(this.sphere.radius)));
        }
    }
}

