/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics.constraints;

import java.util.LinkedList;
import java.util.List;
import toxi.geom.AABB;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.constraints.ParticleConstraint;

public class SoftBoxConstraint
implements ParticleConstraint {
    public AABB box;
    public List<Vec3D.Axis> axes = new LinkedList<Vec3D.Axis>();
    public float smooth;

    public SoftBoxConstraint(AABB aABB, float f) {
        this.box = aABB;
        this.smooth = f;
    }

    public SoftBoxConstraint addAxis(Vec3D.Axis axis) {
        this.axes.add(axis);
        return this;
    }

    public void apply(VerletParticle verletParticle) {
        if (verletParticle.isInAABB(this.box)) {
            for (Vec3D.Axis axis : this.axes) {
                float f = verletParticle.getComponent(axis);
                verletParticle.setComponent(axis, f + (this.box.getComponent(axis) - f) * this.smooth);
            }
        }
    }
}

