/*
 * Decompiled with CFR 0.152.
 */
package toxi.data.feeds.util;

import com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iso8601DateAdapter
extends XmlAdapter<String, XMLGregorianCalendar> {
    public static final SimpleDateFormat[] ISO8601_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};

    public String marshal(XMLGregorianCalendar xMLGregorianCalendar) throws Exception {
        return ISO8601_FORMATS[0].format(xMLGregorianCalendar);
    }

    public XMLGregorianCalendar unmarshal(String string) throws Exception {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DatatypeFactory datatypeFactory = DatatypeFactoryImpl.newInstance();
        for (SimpleDateFormat simpleDateFormat : ISO8601_FORMATS) {
            try {
                Date date = simpleDateFormat.parse(string);
                gregorianCalendar.setTime(date);
                xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
                break;
            }
            catch (ParseException date) {
            }
        }
        if (xMLGregorianCalendar == null) {
            String string2 = string.substring(string.length() - 6);
            string = string.substring(0, string.length() - 6);
            try {
                Date parseException = ISO8601_FORMATS[0].parse(string + "GMT" + string2);
                gregorianCalendar.setTime(parseException);
                xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (ParseException parseException) {
                gregorianCalendar.setTimeInMillis(0L);
                xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            }
        }
        return xMLGregorianCalendar;
    }
}

