/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.erosion;

import toxi.sim.erosion.ErosionFunction;

public class TalusAngleErosion
extends ErosionFunction {
    private float theta;
    private float amount;

    public TalusAngleErosion(float f, float f2) {
        this.theta = f;
        this.amount = f2;
    }

    public void erodeAt(int n, int n2) {
        int n3;
        int n4 = n2 * this.width + n;
        float f = 0.0f;
        float f2 = 0.0f;
        int n5 = 0;
        for (n3 = 0; n3 < 9; ++n3) {
            this.h[n3] = this.elevation[n4 + this.off[n3]];
            this.d[n3] = this.elevation[n4] - this.h[n3];
            if (!(this.d[n3] > this.theta)) continue;
            f2 += this.d[n3];
            ++n5;
            if (!(this.d[n3] > f)) continue;
            f = this.d[n3];
        }
        if (f2 > 0.0f) {
            int n6 = n4;
            this.elevation[n6] = this.elevation[n6] - (f - (float)n5 * f * this.theta / f2);
            for (n3 = 0; n3 < 9; ++n3) {
                if (!(this.d[n3] > this.theta)) continue;
                this.elevation[n4 + this.off[n3]] = this.h[n3] + this.amount * (f - this.theta) * (this.d[n3] / f2);
            }
        }
    }
}

