// Modificado por Juan A. Villalpando
// http://kio4.com/appinventor/8L_firebaseDB_basedatos.htm

var dbRef = new Firebase("https://kio4-3c240.firebaseio.com/");
var base_datosRef = dbRef.child('base_datos')

// Evento cuando añade un elemento. Carga los usuarios viejos y el recién añadido.
base_datosRef.on("child_added", function(snap) {
  document.querySelector('#usuarios').innerHTML += (contactHtmlFromObject(snap.key(),snap.val()));
});
/////////////////////////////////////////////////////////////////////////////////////////

// Evento cuando borra un elemento.
base_datosRef.on("child_removed", function(snap) {
   window.location="index_firebase.html";
});
/////////////////////////////////////////////////////////////////////////////////////////

// Evento cuando edita un elemento.
base_datosRef.on("child_changed", function(snap) {
   window.location="index_firebase.html";
});
/////////////////////////////////////////////////////////////////////////////////////////

// Añade usuario. ADD.
document.querySelector('.addValue').addEventListener("click", function( event ) {  
  event.preventDefault();
  if (document.querySelector('#nombre').value != '') {
	var nombre = document.querySelector('#nombre').value;
	var calle = document.querySelector('#calle').value;
	var ciudad = document.querySelector('#ciudad').value;
	var provincia = document.querySelector('#provincia').value;
	var userRegister = base_datosRef.child(nombre);
    userRegister.set({calle:calle, ciudad:ciudad, provincia:provincia });
	Formulario.reset();
  } else {
    alert('Escriba el nombre del usuario.');
  }
}, false);
/////////////////////////////////////////////////////////////////////////////////////////

// Borrar usuarios. DELETE.
document.querySelector('.deleteValue').addEventListener("click", function( event ) {  
  if (document.querySelector('#nombre').value != '') {
	var nombre = document.querySelector('#nombre').value;
	var userDelete = base_datosRef.child(nombre);
	userDelete.remove();
	var userRegister = base_datosRef.child("-");
    userRegister.set({calle:Math.random(), ciudad:"", provincia:"" });
  } else {
    alert('Escriba el nombre del usuario a borrar.');
  }
}, false);
/////////////////////////////////////////////////////////////////////////////////////////

// Muestra los datos en la página Web HTML.
function contactHtmlFromObject(nombre, values){
  var html = '';
  html += '<li class="list-group usuarios"><div>';
  html += '<p class="lead">'+nombre+'</p>';
  html += '<p><small >'+values.calle+', '+values.ciudad+', '+values.provincia+'</small></p>';
  html += '</div></li>';    
  return html;
}